package w83b.w83bOperacionesPaso.w83bRegistroDefinitivo;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bRegistroDefinitivoBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaActasExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP
	 * @param contexto a
	 * @param mapping a
	 * @param errores a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}
	/**
	 * processForward
	 * @param contexto a
	 * @param mapping a
	 * @param errors a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 * @return ActionForward
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		boolean numRegistroDefinitivo=false;
        HashMap la = (HashMap)contexto.get("w83bResultadoRegistroDefinitivo");
        ArrayList listaActas=(ArrayList)la.get("listaActas");
        for(int i=0;i<listaActas.size();i++){
        	if (((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumRegistroDefinitivo()!=0){
        		numRegistroDefinitivo=true;
        		break;
        	}
        }
        String strRutaExcel;
		if (!numRegistroDefinitivo){
			strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoConsultarActasCerrar.xls";
		}
		else{
			strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelRealizarRegistroDefinitivo.xls";
		}
		
		InputStream inputStream = W83bTablaActasExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        W83bRegistroDefinitivoBean registroDefinitivoBean = (W83bRegistroDefinitivoBean)contexto.get("w83bRegistroDefinitivoBean");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
        HSSFCell cell3;
        HSSFCell cell4;
        
        row = sheet.getRow((short)4);
        if (!numRegistroDefinitivo){ 
            cell = row.getCell((short)5);
        }
        else{
            cell = row.getCell((short)7);
        }
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        
        if (!numRegistroDefinitivo){
        	cell = row.getCell((short)8); 
        }
        else{
        	cell = row.getCell((short)10); 
        }
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        
        
        if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }else if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        	
        row = sheet.getRow((short)6); 
        if (!numRegistroDefinitivo){
        	cell = row.getCell((short)5);
        }
        else{
        	cell = row.getCell((short)7);
        }
        cell.setCellValue(tituloImagenEu.toString());
        
        if (!numRegistroDefinitivo){
        	cell = row.getCell((short)8);
        }
        else{
        	cell = row.getCell((short)10);
        }
         
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow(Short.parseShort("9")); // Creacin de la fila 1
        cell = row.getCell(Short.parseShort("0"));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.tituloExcel",idioma));
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)11); 
      
        if (!numRegistroDefinitivo){
        	cell = row.getCell((short)2); 
        }else{
        	cell = row.getCell((short)3); 
        }
        if(StringUtils.isNotEmpty(registroDefinitivoBean.getDescTerritorio())){
        	cell.setCellValue(registroDefinitivoBean.getDescTerritorio().toUpperCase());        
        }
        if (!numRegistroDefinitivo){
        	cell = row.getCell((short)7); 
        }else{
        	cell = row.getCell((short)8); 
        }
        if(StringUtils.isNotEmpty(registroDefinitivoBean.getFechaEntrada())){
        	cell.setCellValue(registroDefinitivoBean.getFechaEntrada());
        }
        
        if (!numRegistroDefinitivo){
        	cell = row.getCell((short)11); 
        }else{
        	cell = row.getCell((short)13); 
        }
        if(StringUtils.isNotEmpty(registroDefinitivoBean.getFechaEntrada())){
        	cell.setCellValue(registroDefinitivoBean.getFechaRegistro());
        }
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("13"));
        if (!numRegistroDefinitivo){
        	cell = row.getCell(Short.parseShort("0"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_entrada",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_entrada",W83bClsConstantes.CONSTANTE_CASTELLANO));
            
            cell = row.getCell(Short.parseShort("1"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.numEntrada",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.numEntrada",W83bClsConstantes.CONSTANTE_CASTELLANO));
            
            cell = row.getCell(Short.parseShort("2"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.cif",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.cif",W83bClsConstantes.CONSTANTE_CASTELLANO));
            
            cell = row.getCell(Short.parseShort("3"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_CASTELLANO));
            
            cell = row.getCell(Short.parseShort("4"));
            cell2 = row.getCell(Short.parseShort("5"));
            cell3 = row.getCell(Short.parseShort("6"));
            sheet.addMergedRegion(new Region((short)13,(short)4,(short)13,(short)6));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
            
            cell = row.getCell(Short.parseShort("7"));
            cell2 = row.getCell(Short.parseShort("8"));
            cell2 = row.getCell(Short.parseShort("9"));
            sheet.addMergedRegion(new Region((short)13,(short)7,(short)13,(short)9));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.direccion",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.direccion",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
            
            cell = row.getCell(Short.parseShort("10"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.municipio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.municipio",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
            
            cell = row.getCell(Short.parseShort("11"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.sector",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.sector",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
            
            cell = row.getCell(Short.parseShort("12"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.electores",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.electores",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
            
            cell = row.getCell(Short.parseShort("13"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.representantes",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.representantes",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        }
        else{
        	cell = row.getCell(Short.parseShort("0"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.numRegDef",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.numRegDef",W83bClsConstantes.CONSTANTE_CASTELLANO));
            cell = row.getCell(Short.parseShort("1"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_entrada",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.fech_entrada",W83bClsConstantes.CONSTANTE_CASTELLANO));
            cell = row.getCell(Short.parseShort("2"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numacta",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numacta",W83bClsConstantes.CONSTANTE_CASTELLANO));
         
            cell = row.getCell(Short.parseShort("3"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.cif",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.cif",W83bClsConstantes.CONSTANTE_CASTELLANO));
            
            cell = row.getCell(Short.parseShort("4"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_CASTELLANO));
            
            cell = row.getCell(Short.parseShort("5"));
            cell2 = row.getCell(Short.parseShort("6"));
            cell3 = row.getCell(Short.parseShort("7"));
            cell4 = row.getCell(Short.parseShort("8"));
            sheet.addMergedRegion(new Region((short)13,(short)5,(short)13,(short)8));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
            
            cell = row.getCell(Short.parseShort("9"));
            cell2 = row.getCell(Short.parseShort("10"));
            cell3 = row.getCell(Short.parseShort("11"));
            sheet.addMergedRegion(new Region((short)13,(short)9,(short)13,(short)11));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.direccion",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.direccion",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
            
            cell = row.getCell(Short.parseShort("12"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.municipio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.municipio",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
            
            cell = row.getCell(Short.parseShort("13"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.sector",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.sector",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
            
            cell = row.getCell(Short.parseShort("14"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.electores",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.electores",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
            
            cell = row.getCell(Short.parseShort("15"));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.representantes",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.representantes",W83bClsConstantes.CONSTANTE_CASTELLANO)); 
        }
        
        
        for(int i=0;i<listaActas.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.CATORCE+i); // Creacin de la fila 1//NOPMD
        	
        	if (!numRegistroDefinitivo){
        		//Fecha entrada
            	cell = row.createCell((short)0); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getFechaEntrada())){
            		cell.setCellValue(((W83bRegistroDefinitivoBean)listaActas.get(i)).getFechaEntrada());
            	}
            	cell.setCellStyle(this.styleCentrado(i,excel));
            	
            	//N entrada
            	cell = row.createCell((short)1); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumeroEntrada())){
            		cell.setCellValue(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumeroEntrada());
            	}
            	cell.setCellStyle(this.styleCentrado(i,excel));
            	
            	//CIF
            	cell = row.createCell((short)2); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getCif())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bRegistroDefinitivoBean)listaActas.get(i)).getCif()));
            	}
            	cell.setCellStyle(this.styleCentrado(i,excel));
            	
            	//N centro
            	cell = row.createCell((short)3); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumeroCentro())){
            		cell.setCellValue(W83bUtilidades.numero(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumeroCentro()));
            	}
            	cell.setCellStyle(this.styleCentrado(i,excel));
            	
            	//Razn social
            	cell = row.createCell((short)4); 
            	cell2 = row.createCell((short)5);
                cell3 = row.createCell((short)6);
            	sheet.addMergedRegion(new Region((short)W83bClsConstantes.CATORCE+i,(short)4,(short)W83bClsConstantes.CATORCE+i,(short)6));//NOPMD
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getRazon())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bRegistroDefinitivoBean)listaActas.get(i)).getRazon()));
            	}
            	cell.setCellStyle(this.estiloFila(i,excel));
            	cell2.setCellStyle(this.estiloFila(i,excel));
            	cell3.setCellStyle(this.estiloFila(i,excel));
            	
            	//Direccin
            	cell = row.createCell((short)7); 
            	cell2 = row.createCell((short)8);
            	cell3 = row.createCell((short)9);
            	sheet.addMergedRegion(new Region((short)W83bClsConstantes.CATORCE+i,(short)7,(short)W83bClsConstantes.CATORCE+i,(short)9));//NOPMD
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getDireccion())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bRegistroDefinitivoBean)listaActas.get(i)).getDireccion()));
            	}
            	cell.setCellStyle(this.estiloFila(i,excel));
            	cell2.setCellStyle(this.estiloFila(i,excel));
            	cell3.setCellStyle(this.estiloFila(i,excel));
            	
            	//Municipio
            	cell = row.createCell((short)10); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getMunicipio())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bRegistroDefinitivoBean)listaActas.get(i)).getMunicipio()));
            	}
            	cell.setCellStyle(this.estiloFila(i,excel));
            	
            	//COM
            	cell = row.createCell((short)11); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getSeccion())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bRegistroDefinitivoBean)listaActas.get(i)).getSeccion()));
            	}
            	cell.setCellStyle(this.styleCentrado(i,excel));
            	
            	//N trab.
            	cell = row.createCell((short)12); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumTrabajadores())){
            		cell.setCellValue(W83bUtilidades.numero(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumTrabajadores()));
            	}
            	cell.setCellStyle(this.estiloFilaNumero(i,excel));
            	
            	//N rep.
            	cell = row.createCell((short)13); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumDelegados())){
            		cell.setCellValue(W83bUtilidades.numero(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumDelegados()));
            	}
            	cell.setCellStyle(this.estiloFilaNumero(i,excel));
        		
        	}
        	else{
        		//Num reg def
            	cell = row.createCell((short)0); 
            	StringBuffer sb=new StringBuffer(W83bClsConstantes.SEIS);//NOPMD
            	String valor=W83bUtilidadesComunes.rellenarCeros(String.valueOf(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumRegistroDefinitivo()));
            	sb.append(valor);
            	cell.setCellValue(((W83bRegistroDefinitivoBean)listaActas.get(i)).getTerritorio()+"/"+((W83bRegistroDefinitivoBean)listaActas.get(i)).getAnnoRegistro()+"/"+sb.toString());
            	cell.setCellStyle(this.styleCentrado(i,excel));
            	//Fecha entrada
            	cell = row.createCell((short)1); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getFechaEntrada())){
            		cell.setCellValue(((W83bRegistroDefinitivoBean)listaActas.get(i)).getFechaEntrada());
            	}
            	cell.setCellStyle(this.styleCentrado(i,excel));
            	
            	//N entrada
            	cell = row.createCell((short)2);
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumeroEntrada())){
            		cell.setCellValue(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumeroEntrada());
            	}
            	cell.setCellStyle(this.estiloFilaNumero(i,excel));
            	
            	//CIF
            	cell = row.createCell((short)3); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getCif())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bRegistroDefinitivoBean)listaActas.get(i)).getCif()));
            	}
            	cell.setCellStyle(this.styleCentrado(i,excel));
            	
            	//N centro
            	cell = row.createCell((short)4); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumeroCentro())){
            		cell.setCellValue(W83bUtilidades.numero(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumeroCentro()));
            	}
            	cell.setCellStyle(this.styleCentrado(i,excel));
            	
            	//Razn social
            	cell = row.createCell((short)5); 
            	cell2 = row.createCell((short)6); 
            	cell3 = row.createCell((short)7);
                cell4 = row.createCell((short)8);
            	sheet.addMergedRegion(new Region((short)W83bClsConstantes.CATORCE+i,(short)5,(short)W83bClsConstantes.CATORCE+i,(short)8));//NOPMD
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getRazon())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bRegistroDefinitivoBean)listaActas.get(i)).getRazon()));
            	}
            	cell.setCellStyle(this.estiloFila(i,excel));
            	cell2.setCellStyle(this.estiloFila(i,excel));
            	cell3.setCellStyle(this.estiloFila(i,excel));
            	cell4.setCellStyle(this.estiloFila(i,excel));
            	
            	//Direccin
            	cell = row.createCell((short)9); 
            	cell2 = row.createCell((short)10); 
            	cell3 = row.createCell((short)11); 
            	sheet.addMergedRegion(new Region((short)W83bClsConstantes.CATORCE+i,(short)9,(short)W83bClsConstantes.CATORCE+i,(short)11));//NOPMD
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getDireccion())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bRegistroDefinitivoBean)listaActas.get(i)).getDireccion()));
            	}
            	cell.setCellStyle(this.estiloFila(i,excel));
            	cell2.setCellStyle(this.estiloFila(i,excel));
            	cell3.setCellStyle(this.estiloFila(i,excel));
            	
            	//Municipio
            	cell = row.createCell((short)12); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getMunicipio())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bRegistroDefinitivoBean)listaActas.get(i)).getMunicipio()));
            	}
            	cell.setCellStyle(this.estiloFila(i,excel));
            	
            	//COM
            	cell = row.createCell((short)13);
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getSeccion())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bRegistroDefinitivoBean)listaActas.get(i)).getSeccion()));
            	}
            	cell.setCellStyle(this.styleCentrado(i,excel));
            	
            	//N trab.
            	cell = row.createCell((short)14); 
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumTrabajadores())){
            		cell.setCellValue(W83bUtilidades.numero(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumTrabajadores()));
            	}
            	cell.setCellStyle(this.estiloFilaNumero(i,excel));
            	
            	//N rep.
            	cell = row.createCell((short)15);
            	if(StringUtils.isNotEmpty(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumDelegados())){
            		cell.setCellValue(W83bUtilidades.numero(((W83bRegistroDefinitivoBean)listaActas.get(i)).getNumDelegados()));
            	}
            	cell.setCellStyle(this.estiloFilaNumero(i,excel));
        	}
        	
        	
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=ListadoRegDefinitivo.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	/**
	 * Estilo fila numero.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumero(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumero;
		}else{
			return excel.styleTextoImparNumero;			
		}
		
	}
	
	private HSSFCellStyle styleCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParCentrado;	
		}else{
			return excel.styleTextoImparCentrado;		
		}
				
		
	}

}
